/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.redpxnda.nucleus.util.RenderUtil;
import com.redpxnda.respawnobelisks.config.ReviveConfig;
import com.redpxnda.respawnobelisks.registry.block.RespawnObeliskBlock;
import com.redpxnda.respawnobelisks.registry.block.entity.RespawnObeliskBlockEntity;
import com.redpxnda.respawnobelisks.registry.particle.ChargeIndicatorParticle;
import java.lang.invoke.StringConcatFactory;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BlazeModel;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.BlazeRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtils {
    private static Map<String, ResourceLocation> THEME_TEXTURES = new HashMap<String, ResourceLocation>();
    private static Map<String, TextureAtlasSprite> THEME_SPRITES = new HashMap<String, TextureAtlasSprite>();
    private static ItemStack TOTEM_STACK;
    private static Blaze BLAZE;
    public static final Multimap<BlockPos, ChargeIndicatorParticle> CHARGE_PARTICLES;
    public static final Vector3f[] runeCircleColors;

    public static Map<String, ResourceLocation> getThemeTextures() {
        return THEME_TEXTURES;
    }

    public static void registerPackTexture(String id, ResourceLocation location) {
        THEME_TEXTURES.put(id, location);
    }

    public static TextureAtlasSprite getAtlasSprite(String sprite) {
        if (!THEME_SPRITES.containsKey(sprite)) {
            THEME_SPRITES.put(sprite, (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(THEME_TEXTURES.get(sprite)));
        }
        return THEME_SPRITES.get(sprite);
    }

    public static void renderBlaze(RespawnObeliskBlockEntity be, float partialTick, PoseStack poseStack, MultiBufferSource buffer) {
        int i;
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        renderManager.m_114468_(false);
        if (Minecraft.m_91087_().f_91073_ == null || be.m_58904_() == null) {
            return;
        }
        if (BLAZE == null) {
            BLAZE = new Blaze(EntityType.f_20551_, (Level)Minecraft.m_91087_().f_91073_);
        }
        BlockPos pos = be.m_58899_();
        BLAZE.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        float renderTicks = (float)be.m_58904_().m_46467_() + partialTick;
        poseStack.m_85836_();
        poseStack.m_85837_(0.375, (double)-0.65f, 0.6125);
        poseStack.m_85841_(1.4f, 1.4f, 1.4f);
        BlazeRenderer renderer = (BlazeRenderer)renderManager.m_114382_((Entity)BLAZE);
        ((BlazeModel)renderer.m_7200_()).m_142109_().m_171324_((String)"head").f_104207_ = false;
        for (i = 4; i < 12; ++i) {
            ((BlazeModel)renderer.m_7200_()).m_142109_().m_171324_((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"part\u0001"}, (int)i))).f_104207_ = false;
        }
        renderManager.m_114384_((Entity)BLAZE, 0.0, 0.0, 0.0, 0.0f, renderTicks, poseStack, buffer, 0xFFFFFF);
        renderManager.m_114468_(true);
        ((BlazeModel)renderer.m_7200_()).m_142109_().m_171324_((String)"head").f_104207_ = true;
        for (i = 4; i < 12; ++i) {
            ((BlazeModel)renderer.m_7200_()).m_142109_().m_171324_((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"part\u0001"}, (int)i))).f_104207_ = true;
        }
        poseStack.m_85849_();
    }

    public static void renderRunes(TextureAtlasSprite sprite, RespawnObeliskBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        RenderUtils.renderRunes(sprite, new float[]{1.0f, 1.0f, 1.0f}, blockEntity, partialTick, poseStack, bufferSource, packedLight);
    }

    public static void renderRunes(TextureAtlasSprite sprite, float[] colors, RespawnObeliskBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        VertexConsumer vc = bufferSource.m_6299_(RenderType.m_110466_());
        poseStack.m_85837_(0.5, 1.125, 0.5);
        for (int i = 0; i < 4; ++i) {
            RenderUtil.addQuad((boolean)false, (Matrix4f)poseStack.m_85850_().m_85861_(), (VertexConsumer)vc, (float)colors[0], (float)colors[1], (float)colors[2], (float)((float)(blockEntity.getClientCharge() / blockEntity.getClientMaxCharge())), (float)0.28125f, (float)0.75f, (float)-0.3438125f, (float)0.0f, (float)sprite.m_118367_(3.0), (float)sprite.m_118367_(12.0), (float)sprite.m_118393_(2.0), (float)sprite.m_118393_(14.0), (int)packedLight);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        }
        poseStack.m_85849_();
    }

    public static void renderSculkTendrils(RespawnObeliskBlockEntity blockEntity, PoseStack poseStack, TextureAtlasSprite sprite, MultiBufferSource buffer, int light) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 2.125, 0.5);
        VertexConsumer vc = buffer.m_6299_(RenderType.m_110466_());
        int direction = 0;
        switch ((Direction)blockEntity.m_58900_().m_61143_((Property)RespawnObeliskBlock.RESPAWN_SIDE)) {
            case EAST: {
                direction = 1;
                break;
            }
            case SOUTH: {
                direction = 2;
                break;
            }
            case WEST: {
                direction = 3;
            }
        }
        float size = 0.3125f;
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)(90 * direction)));
        RenderUtil.addDoubleQuad((PoseStack)poseStack, (VertexConsumer)vc, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)size, (float)size, (float)0.0f, (float)-0.71875f, (float)sprite.m_118367_(7.25), (float)sprite.m_118367_(8.5), (float)sprite.m_118393_(0.75), (float)sprite.m_118393_(2.0), (int)light);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        RenderUtil.addDoubleQuad((PoseStack)poseStack, (VertexConsumer)vc, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)size, (float)size, (float)0.0f, (float)-0.71875f, (float)sprite.m_118367_(7.25), (float)sprite.m_118367_(8.5), (float)sprite.m_118393_(0.75), (float)sprite.m_118393_(2.0), (int)light);
        poseStack.m_85849_();
    }

    public static void renderRainbow(float progress, float alpha, RespawnObeliskBlockEntity blockEntity, PoseStack poseStack, TextureAtlasSprite sprite, MultiBufferSource buffer, int light) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 2.5, 0.5);
        VertexConsumer vc = buffer.m_6299_(RenderType.m_110466_());
        int direction = 0;
        switch ((Direction)blockEntity.m_58900_().m_61143_((Property)RespawnObeliskBlock.RESPAWN_SIDE)) {
            case EAST: {
                direction = 1;
                break;
            }
            case SOUTH: {
                direction = 2;
                break;
            }
            case WEST: {
                direction = 3;
            }
        }
        float size = 4.0f;
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)(90 * direction)));
        RenderUtil.addQuad((f, bl) -> Float.valueOf((bl != false ? f.floatValue() : 0.0f) - size / 2.0f), (f, bl) -> Float.valueOf((bl != false ? 0.0f : f.floatValue()) - size / 2.0f), (Matrix4f)poseStack.m_85850_().m_85861_(), (VertexConsumer)vc, (float)1.0f, (float)1.0f, (float)1.0f, (float)alpha, (float)(size * progress), (float)size, (float)0.0f, (float)sprite.m_118409_(), (float)sprite.m_118367_((double)(progress * 16.0f)), (float)sprite.m_118411_(), (float)sprite.m_118412_(), (int)light);
        RenderUtil.addQuad((f, bl) -> Float.valueOf(0.0f - size / 2.0f), (f, bl) -> Float.valueOf(f.floatValue() - size / 2.0f), (Matrix4f)poseStack.m_85850_().m_85861_(), (VertexConsumer)vc, (float)1.0f, (float)1.0f, (float)1.0f, (float)alpha, (float)(size * progress), (float)size, (float)0.0f, (float)sprite.m_118409_(), (float)sprite.m_118367_((double)(progress * 16.0f)), (float)sprite.m_118412_(), (float)sprite.m_118411_(), (int)light);
        poseStack.m_85849_();
    }

    public static void renderRuneCircle(long time, float scale, Vector3f[] colors, float alpha, float x, float y, float z, SpriteSet set, Vector3f[] vertices, VertexConsumer vc, int light) {
        RenderUtil.rotateVectors((Vector3f[])vertices, (Quaternion)Vector3f.f_122223_.m_122240_(90.0f));
        for (int i = 1; i < 5; ++i) {
            time = (long)((float)time * (1.0f + (float)i / 5.0f));
            if (i % 2 == 0) {
                RenderUtil.rotateVectors((Vector3f[])vertices, (Quaternion)Vector3f.f_122225_.m_122240_((float)time));
            } else {
                RenderUtil.rotateVectors((Vector3f[])vertices, (Quaternion)Vector3f.f_122224_.m_122240_((float)time));
            }
            RenderUtil.scaleVectors((Vector3f[])vertices, (float)scale);
            TextureAtlasSprite sprite = set.m_5819_(i, 4);
            RenderUtil.translateVectors((Vector3f[])vertices, (float)x, (float)(y + 0.01f * (float)i), (float)z);
            RenderUtil.addParticleQuad((Vector3f[])vertices, (VertexConsumer)vc, (float)colors[i % 2].m_122239_(), (float)colors[i % 2].m_122260_(), (float)colors[i % 2].m_122269_(), (float)alpha, (float)sprite.m_118409_(), (float)sprite.m_118410_(), (float)sprite.m_118411_(), (float)sprite.m_118412_(), (int)light);
            RenderUtil.translateVectors((Vector3f[])vertices, (float)(-x), (float)(-y), (float)(-z));
            RenderUtil.scaleVectors((Vector3f[])vertices, (float)(1.0f / scale));
            if (i % 2 == 0) {
                RenderUtil.rotateVectors((Vector3f[])vertices, (Quaternion)Vector3f.f_122224_.m_122240_((float)time));
                continue;
            }
            RenderUtil.rotateVectors((Vector3f[])vertices, (Quaternion)Vector3f.f_122225_.m_122240_((float)time));
        }
    }

    public static void renderTotemItem(BlockEntityRendererProvider.Context context, RespawnObeliskBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 2.5, 0.5);
        poseStack.m_85841_(1.5f, 1.5f, 1.5f);
        if (blockEntity.m_58904_() != null) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)(blockEntity.m_58904_().m_46467_() % 360L)));
        }
        ItemRenderer itemRenderer = context.m_234447_();
        if (TOTEM_STACK == null) {
            TOTEM_STACK = new ItemStack((ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation(ReviveConfig.revivalItem)));
        }
        itemRenderer.m_174269_(TOTEM_STACK, ItemTransforms.TransformType.GROUND, packedLight, packedOverlay, poseStack, bufferSource, 1);
        poseStack.m_85849_();
    }

    static {
        RenderUtils.registerPackTexture("sculk_tendrils", new ResourceLocation("minecraft", "entity/warden/warden"));
        RenderUtils.registerPackTexture("rainbow", new ResourceLocation("respawnobelisks", "block/rainbow"));
        TOTEM_STACK = null;
        BLAZE = null;
        CHARGE_PARTICLES = HashMultimap.create();
        runeCircleColors = new Vector3f[]{new Vector3f(0.07450981f, 0.5568628f, 0.6f), new Vector3f(0.16078432f, 0.8745098f, 0.92156863f)};
    }
}

